# README for qownbackup system version 0.90

By Steve Litt, slitt@troubleshooters.com

## Documentation Files

* README.FIRST: Tells what to do with the rest of the documentation.
* README.md gives general and detailed info on the behavior and usage of the qownbackup system.
* BUGS.md lists known and likely bugs, unexpected behaviors, and untested assumptions.
* INSTALL.md details how to install and configure 
* PHILOSOPHY.md: Why this system was made, who it was made for, and why certain decisions were made.
* COPYING.md: The copyright and license.
* MANIFEST.md: List of included files.
* BUGS.md: Lists the bugs.

Note that there are HTML versions of these files in the `docs/html` subdirectory of your qownbackup system program directory.

## PURPOSE

The purpose of the qownbackup system is to provide continuous and incremental backups of all Markdown files.

A basic design criteria of the QOwnNotes program is an autosave that relieves the user of the need to save his or her work. Most people like it just this way. But this behavior leads to a situation where if the user isn't linking their file to OwnCloud or NextCloud, then if the file gets garbled beyond the ability to undo with Ctrl+z, or if QOwnNotes is terminated right after the garbling, the garbled (or deleted) version is the only one left. Some people don't like this risk.

The qownbackup system is designed to prevent this risk. Assuming the software's $my\_interval\_seconds is set to the recommended 61, the most work you can lose is the last 71 seconds (61 plus the up to 10 seconds until
QOwnNotes' next autosave.

An additional benefit is you have a copy of every version going back in time, at least until the latest undeleted time. Obviously, for disk space's sake you'll want to prune the backup tree, but the assumption is that before then your backup tree will have made it into your regularly scheduled backups.

To conserve disk space, the qownbackup system backs up only changed files. The following command shows all revisions of a given \<filename\>:

`./qownbackup show_revisions <filename>`

## DECISIONS

Like all software, the qownbackup system was created using design decisions. Some of those decisions were be tough calls, and some will be disliked by a significant amount of users. If the majority dislike a decision, I can always change it and bring out a new version. The remainder of this section showcases the individual decisions...

## Command Syntax

To use this system, perform the following actions from a shellscript or keyboard:

```
cd </path/to/install/directory>
./qownbackup.sh <command> <options>
```  

Each option will begin with a single hyphen, followed by a single letter, optionally followed by a value, 
but currently there are no options recognized. The command will be one of:

* `backup` , which runs a forever backup system for the `.md` files in your QOwnNotes directory.
* `sync` , which copies all files in qownbackup system's "latest" directory to a brand new incremental directory.
    * Do this when the qownbackup system has been down long enough to possibly miss changes. Do it before resuming the forever backup.
* `list` , list all `.md` files in your QOwnNotes directory.
* `versions <filename>` : Find and list all versions of this file in the backup tree.
* `versions_long` : Same as `versions`, but instead of just listing filenames, it also prints out the version's contents. Currently does nothing.
    * Best piped into a `less` command.

Note that `qownbackup.sh backup` is typically  executed as a background process (daemon) as the logged in user. 
Accomplishing this is detailed in the`INSTALL.md` file.
