PHILOSOPHY: qownbackup system version 0.90
========================

## What is the qownbackup system?

The qownbackup system is a system for automatically backing up your QOwnNotes *.md files in the root of your QOwnNotes directory. You can identify this directory by Note=>Setup Note Folders=>Note Folder=>Default=>Note folder path. Default for Void Linux is $HOME/qownNotes.

The reason for this backup system is that if you made a huge mistake on one of your QOwnNotes notes, waited several seconds, and then exited QOwnNotes, the changes would be irrevocably written to disk and you cannot get your good content back. If you were to accidentally delete a note, the note is gone forever. If you discover a large mistake or deletion in a note, you have no prior backups to go back to. When used properly, and it's easy to use the qownbackup system properly, you have backups of each file's changes to a precision of 61 seconds, perhaps less if you change a setting.

## Priorities

Every software system has priorities. The following are the priorities used in creating the qownbackup system...

### Consistency

The qownbackup system is created to work the same way every time. This minimizes user surprise and bugs, and keeps special cases out of the code base.

### Simplicity

Simplicity is a priority in the qownbackup system. One person wrote it, one person tested it, and for at least the immediate future, one person will need to maintain it in his spare time. Beyond these reasons, another reason for keeping it simple is because many people prefer using simple software so they can troubleshoot problems easily, and perhaps use its tiny source code base to augment knowledge gained from its documentation. Believe me, the documentation files use many more bytes than the source.

The qownbackup system uses no compression, no de-duplication, no differential backup. It makes a separate (not hard link) copy of every version of every *.md file in the default folder, and has no quick-tricks for deducing that a file has changed. File changes are deduced by diffing every *.md file within the default folder. If your default note folder contains 20 book length notes (let's say 3/4 of a Megabyte apiece, I'd expect performance to start to fall and processor usage to rise. It's not infinitely scalable, but I'm pretty sure that if you keep less than 200 markdown files controlled by QOwnNotes, performance will be just fine.

### Good Documentation

Much excellent software goes unused because of poor documentation. The qownnotes system's docs are much more Kilobyte consuming than the actual code, and that's a good thing. The author of the qownnotes system, Steve Litt, is known for excellent, unambiguous and easy to use documentation.

### Resourceful Users

There's a class of Linux users who, when asked to edit a file, throw up their hands and proclaim "I am not a programmer!" This type of user should not attempt to use the qownbackup system. File editing, the ability to access a terminal and type simple commands, a passing knowledge of how files and directories work in POSIX-like environments, and perhaps the ability to write and use a 4 line shell script, are necessary.

The qownbackup system has no GUI, because on simple programs the GUI doubles or triples the size and complexity of the code, increases the attack surface, and provides many more places for bugs to hide. I spent all my time on making the program function well.

The qownbackup system is very discoverable. Typing `./qownbackup.sh` without arguments brings up a "Usage " screen listing and explaining all possible command syntaxes.

### Get It Done

The perfect is the enemy of the good. Authors demanding perfection, whether book authors or software authors, never publish, because there's always more to do. I wanted to get this software out as soon as it worked well on my Void-Linux computer.

### Non-priorities

* Pretty: It's a backup program, not a work of art. All my time went into making it work well.
* Speed: It could be much faster written in C, but as-is it's more than fast enough to handle a fast touch-typist's workflow.
* Widespread Adoption: It works for me. I'm sure some others will find it handy, and some won't, which is fine.
* Windows, Mac, and mobile device support. If the qownbackup system becomes popular, these things would be easy enough to put in, and the software will probably be written in Python.



## Alternatives to the qownbackup system

There are alternatives to the qownbackup system. If you connect your QOwnNotes to OwnCloud or NextCloud, you might get some of the same backup features. And of course you can put your whole QOwnNotes data tree under Git, which would be a more complete and reliable system, but then you'd need to remember to manually do `git add` and `git commit`. The qownbackup system is for those desiring automatic multiversion backups.

## Why ...

Here are some answers to obvious questions...


### WHY NOT git?

The git version control system could track your QOwnNotes directory's .md files perfectly, bestowing almost all the same benefits as the qownbackup system, and more. The one benefit of the qownbackup system unmatched by git is
unattended backup of all versions. This matches QOwnNotes workflow, because QOwnNotes does unattended saves. This is why I created the qownbackup system.

### Why Such Deep Directories?

The qownbackup system's backups occur in a minute directory under an hour directory under a day directory under a month directory under a year directory. That's a deep dive. The backup date and time could have been incorporated in the filename, eliminating the need for all these directories so that all backups appear in a single directory, which would be much simpler, especially with reporting versions of files.

The trouble with everything in one directory is that the Linux Ext4 filesystem slows down when a directory contains 1000 files, and slows to a crawl with 10,000 files in one directory. The user with many QOwnNotes files to back up, who edits all those files regularly, will soon hit 1,000 files, and eventually hit 10,000. To prevent such a problem, backups are contained in a tree rather than a single directory.

### Why Limit Precision to a Minute?

The current version of qownbackup stores backup files in directories of the form `$my_qown_backup_dir/inc%Y/%m/%d/%H/%M`. This means that if two backups occur in the same minute, the later would overwrite the earlier. I could have avoided this by appending `/%S` to the directory, thereby making backups down to the second. But for simplicity, and not wanting to go any deeper, I chose not to. The recommended $my\_interval\_seconds setting of 61 means a backup is taken at most every 71 seconds: 61 for the interval and up to 10 for QOwnNotes to update the disk to match what's on the QOwnNotes window.

Given that QOwnNotes has an "undo" command triggered by the Ctrl+z hotkey, I think that losing 71 seconds of work very occasionally is a good tradeoff. Note also that you could set $my_interval_seconds down as low as 40, and such overwrites would usually not happen, and if they did happen you'd just lose 51 seconds of work. I don't recommend this, but you could do it.

### Why Require a Distinct Installation Directory?

The qownbackup system must all be installed in its own directory tree, not in various places dictated by UNIX customs (/usr/bin, /etc and the like). What about the Linux Standard Base (LSB), which encodes those UNIX customs into a specification. I made the single tree install decision because:

* Ease of installation, just  just a `tar xzvf <tgzname>`
* Ease of uninstall, just `rm -rf dirname`
* Simplicity.
* Ironclad file naming scope.
* Ease of debugging.

Furthermore, unlike large programs, there's almost no downside to having the installation in one directory tree because:

* The entire installation is less than 145 KB, meaning 1000 users could implement their own installations in less than 145 MB. Of the 145, 52 KB are documentation, which could, if desired, be placed in a separate location and then deleted from each user's directory.
* It's all shellscripts (with possible Python files later).
* No libraries or dependencies.
* Installation directory contains only executables, config shellscripts, and documentation, no data. Your QOwnNotes-created Markdown files are in a different directory.

#### But what about package managers?

Most package managers declare that they should be used only for globally installed executables,  not per-user installations. The qownbackup system is designed to be individually installed for each user. It's so small that less than 145 KB per user is saved by a machine-wide or network-wide installation. Not only that, but per-user installation means the program's configuration needn't be installed in, let me count the choices, `$HOME/.qownbackup`, `$HOME/.config/qownbackup`, oh, and by the way, does that file replace the file in `/etc` (or `/etc/qownbackup`), or just modify it?

When I was the maintainer of the VimOutliner project, and also during the many-years' service of the maintainer after me, we learned that the first step of debugging was to have them install directly from our tarball, not the distro-provided package. Because the distro-provided packages often complexified the situation and even added bugs.

#### But what about updates to qownbackup?

Just rename the existing install directory, create a new one, and untar. If, after a few weeks, the new version
is working with no problems, delete the old, renamed tree.

#### But what about users not "technical enough" to untar or rm? 

Ah, the famous "I am not a programmer" objection. Personally, I have more faith in humanity than that. I believe
that almost everyone can follow instructions to `cd` to somewhere and then either `tar xzvf <tarballname>` to install, and in order to update,
`rm -rf <installdirname>` to uninstall, or `mv <currentinstalldirname> <backupinstalldirname>` and then
`tar xzvf <tarballname>` to update with the option to go back. Those who can't do these tasks would probably have a lot of trouble operating a package manager, so same difference. And once again, universal adoption is not one of this program's priorities. 

#### But what about the Linux Standard Base (LSB)?

Asked and answered. Conforming to LSB on this tiny system would be an unnecessary complication and a hassle.

#### But I want my qownnotes backup system command on the executable path!

I wouldn't blame you. Doing so is as easy as placing the following executable shellscript on your
executable path:

```
#!/bin/sh
cd </path/to/install/directory>
./qownbackup.sh $@
```  

Notice the `.sh` extension in the preceding. This is specifically so you can call your on-the-path shellscript
`qownbackup` or `qb` or whatever you want for ease of typing.

##### Why didn't you make that shellscript for the user?

Because setting a directory is necessary and could be dangerous if set wrong.

##### Why didn't you make the qownbackup system find the directory on installation?

If the user can't make their own shellscript, they can't be trusted to type in a proper directory during installation.

### Why Only .md Files?

It seemed like a good place to stop, until I find out more about file and directory naming workflow of other people.

### Why Not Descend Directories in the QOwnNotes Directory?

Not descending seemed like a good place to stop, until I find out more about file and directory naming workflow of other people.

### Why No Backup Pruning?

Eventually, which could measure weeks or years, the backups will be too voluminous and disk-consuming. When that happens, the backups must be pruned (earlier or less important backups deleted). The "how much is too much" decision depends on personal workflow and preferences, and would probably have all sorts of combinations of ages and importances, together with some exceptions to rules. It would be much easier for the user to prune manually, or to create his/her own pruning shellscript, than for the user to use a configurable one-size-fits-all pruning ruleset.

### Why No HTML Documentation?

There *is* HTML documentation. See the `docs/html` directory in the qownbackup program tree.

