INSTALLING THE QOWNBACKUP SYSTEM: Version 0.90
========================

## Know this first

* The qownbackup system is meant to be installed on a per-user basis. See PHILOSOPHY.md for reasons.
* The qownbackup system is installed as a single directory tree, making installation and uninstallation easy. 
* If you change the location of the tree, known as the qownbackup system program directory, you must change any procedures and shell scripts that refer to it.

## To Install

* Obtain qownbackup_0.90.tgz
* Choose or create a directory, readable and writeable by the user who will be using the qownbackup system, to serve as the *parent directory* of the qownbackup system program directory. We highly recommend using the user's home directory (`$HOME`) for this unless you have a reason not to. 

* Pertaining to the preceding step, if you already installed the qownbackup system program directory elsewhere and want to change its location to the recommended location, you can must use the `mv` command to do so. For instance,             
```   mv /where/ever/qownbackup_installed $HOME/qownbackup_installed```

* `cd` into the directory from the preceding step
* tar xzvf qownbackup_0.90.tgz to create the qownbackup program directory
* `cd` into the directory created by the preceding step
* Edit file qownconstants.inc to reflect the locations of your QOwnNotes directory to reflect your setup's:
    * qb_qown_dir : Location your QOwnNotes places its *.md files. Default $HOME/qownNotes
    * qb_qown_backup_dir : Head of the tree that will contain the backups. Default $HOME/qownbackupdir
    * qb_qown_backup_latest_dir : Directory for latest backup versions. Default $qb_qown_backup_dir . Leave at the default unless you have an extremely good reason to do otherwise.
    * qb_log_dir: Directory where the backup log goes. Default $HOME/qownLog
    * qb_log_file: File containing backup log. Default $qb_log_dir/qb.log
    * qb_interval_seconds: Interval in seconds between backup scans. Default 61.

## To Test

* `cd` to the qownbackup system program directory you created during the install.
* `./qownbackup.sh` in order to see the usage message.
* `./qownbackup.sh backup` in order to start the continuous backup process.
* `./qownbackup check` in order to make sure the qownbackup system's continuous backup is running. It's working properly if one process, whose parent PID is 1, is listed.
* `./qownbackup.sh list` to list the backed up files.
* `./qownbackup.sh versions <filename>` to list all backed up versions of a file.

## To Autostart backup loop on login

Because the qownbackup system is user specific, it shouldn't be started from your init system or process supervisor. Instead, it should be started when you first log in, using the following shell script code:

```
 cd $HOME/qownbackup_installed
./doublefork_qownbackup.forker
```

The preceding code assumes your qownbackup system directory is `$HOME/qownbackup_installed`. If not, change the preceding code accordingly. The preceding code segment must be placed in a file executed by the user's shell upon login. Assuming the user's shell is `bash`, this code should be placed in the file `$HOME/.bash_profile`. It should appear before any `exec` or `source` or dot commands, because if it were after those commands, it would never get executed.

### About doublefork_qownbackup.forker

`doublefork_qownbackup.forker` is a binary executable that double-forks the command `./qownbackup.sh backup`. It's a static binary compiled using the MUSL library from the `doublefork_qownbackup.c` source file. It *should* work on any Linux computer. If you're using a different OS or for some other reason it doesn't work for you, you can compile it from  `doublefork_qownbackup.c`, name the resulting binary `doublefork_qownbackup.forker`, and place it in your qownbackup system program directory.

## For Simpler Use

This is optional for those who want to reduce keystrokes. Don't do it unless you have an idea of what shell scripts are, as well as how Linux organizes its files and directories.

* Find a directory for this user that's on the executable path. `$HOME/bin` is the usual suspect.
* Within that directory place a shell script that `cd`s to the qownbackup system's program directory, and then runs `./qownbackup.sh $@`
* Make that file executable.
* For quick typing, I call my shell script `qb`

